/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.andavin.images.Images;
import com.andavin.images.PacketListener;
import com.andavin.images.command.BaseCommand;
import com.andavin.images.command.DeleteNearCommand;
import com.andavin.images.image.CustomImage;
import com.andavin.util.ActionBarUtil;
import com.andavin.util.MinecraftVersion;
import com.andavin.util.Scheduler;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

final class DeleteCommand
extends BaseCommand
implements Listener {
    private final Set<UUID> deleting = new HashSet<UUID>();

    DeleteCommand() {
        super("delete", "images.command.delete");
        this.setAliases("del", "remove", "unload");
        this.setUsage("/image delete");
        this.setDesc("Delete an existing image by clicking on it");
        this.addChild(new DeleteNearCommand());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Images.getInstance());
    }

    @Override
    public void execute(Player player, String label, String[] args) {
        if (this.cancel(player)) {
            return;
        }
        UUID id = player.getUniqueId();
        this.deleting.add(id);
        Scheduler.repeatAsyncWhile(() -> {
            if (MinecraftVersion.lessThan(MinecraftVersion.v1_15)) {
                ActionBarUtil.sendActionBar(player, "\u00a7eRight Click to delete\u00a77 - \u00a7eLeft Click to cancel");
            } else {
                ActionBarUtil.sendActionBar(player, "\u00a7eRight Click to delete\u00a77 - \u00a7eRerun Command to cancel");
            }
        }, 5L, 20L, () -> this.deleting.contains(id));
        Images.addListenerTask(player, (clicker, image, section, action, hand) -> {
            if (!image.getCreator().equals(CustomImage.UNKNOWN_CREATOR) && Images.getInstance().getConfig().getBoolean("permissions.creator-restricted") && !player.getUniqueId().equals(image.getCreator()) && !player.hasPermission("images.restricted.bypass")) {
                player.sendMessage("\u00a7cInsufficient permission to modify that image");
                return;
            }
            if (action == PacketListener.InteractType.RIGHT_CLICK) {
                Scheduler.async(() -> {
                    if (this.deleting.remove(player.getUniqueId()) && Images.removeImage(image)) {
                        image.destroy();
                        player.sendMessage("\u00a7aImage successfully deleted");
                    } else {
                        player.sendMessage("\u00a7cFailed to delete image");
                    }
                });
            }
        });
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        switch (event.getAction()) {
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                if (!MinecraftVersion.lessThan(MinecraftVersion.v1_15) || !this.cancel(event.getPlayer())) break;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onAnimate(PlayerAnimationEvent event) {
        if (MinecraftVersion.lessThan(MinecraftVersion.v1_15)) {
            this.cancel(event.getPlayer());
        }
    }

    private boolean cancel(Player player) {
        if (this.deleting.remove(player.getUniqueId())) {
            player.sendMessage("\u00a7cDeletion cancelled");
            return true;
        }
        return false;
    }
}

